# Nyazo для Android

> ⚠️ **Дисклеймер:** Этот проект нашкодлен с помощью нейрослопинга ленивым дурачком.

Автоматическая загрузка скриншотов на собственный сервер. Аналог Gyazo/ShareX для Android.

---

## 🎯 Возможности

- ✅ **Автоматическое обнаружение скриншотов** - работает на главном экране и внутри приложений
- ✅ **Загрузка на сервер** - мгновенная загрузка на ваш PHP endpoint
- ✅ **Копирование ссылки** - автоматически в буфер обмена
- ✅ **История загрузок** - список всех загруженных скриншотов
- ✅ **Удаление с сервера** - через интерфейс приложения с паролем
- ✅ **Минимальное уведомление** - не раздражает
- ✅ **Автозапуск** - после перезагрузки

## 🏗️ Как работает

**ScreenshotDetectionService** - фоновый сервис с ContentObserver + polling каждые 2 секунды. Отлавливает файлы начинающиеся с "screenshot", конвертирует JPG→PNG, отправляет на сервер через OkHttp.

**HistoryManager** - сохраняет историю в SharedPreferences (JSON), до 100 записей.

**UploadManager** - загружает файлы multipart/form-data, удаляет через POST на `/del/filename.png` с паролем.

---

## 🚀 Сборка Nyazo Android с нуля

### 📦 Блок 1: Установка JDK и базовых инструментов

**Arch Linux:**
```bash
sudo pacman -S jdk17-openjdk android-tools git
```

**Debian/Ubuntu:**
```bash
sudo apt update
sudo apt install openjdk-17-jdk adb git wget unzip -y
```

***

### 📱 Блок 2: Установка Android SDK

```bash
# Создаём директорию для SDK
mkdir -p ~/Android/Sdk/cmdline-tools
cd ~/Android/Sdk/cmdline-tools

# Скачиваем command-line tools (актуальная версия)
wget https://dl.google.com/android/repository/commandlinetools-linux-11076708_latest.zip

# Распаковываем
unzip commandlinetools-linux-*.zip
mv cmdline-tools latest
cd ~

# Удаляем архив
rm ~/Android/Sdk/cmdline-tools/commandlinetools-linux-*.zip
```

***

### 🔧 Блок 3: Настройка переменных окружения

```bash
# Добавляем в ~/.bashrc (или ~/.zshrc)
cat >> ~/.bashrc << 'EOF'

# Android SDK
export ANDROID_HOME=$HOME/Android/Sdk
export PATH=$PATH:$ANDROID_HOME/cmdline-tools/latest/bin
export PATH=$PATH:$ANDROID_HOME/platform-tools
export PATH=$PATH:$ANDROID_HOME/emulator
EOF

# Применяем изменения
source ~/.bashrc
```

***

### 📥 Блок 4: Установка Android SDK компонентов

```bash
# Принимаем лицензии
yes | sdkmanager --licenses

# Устанавливаем необходимые пакеты
sdkmanager "platform-tools" \
           "platforms;android-35" \
           "build-tools;35.0.0" \
           "cmdline-tools;latest"

# Проверка установки
sdkmanager --list_installed
```

***

### 📂 Блок 5: Клонирование проекта

```bash
# Клонируем из GitLab
cd ~/Documents
git clone https://gitlab.com/username/nyazo-android.git
cd nyazo-android

# Создаём local.properties (ОБЯЗАТЕЛЬНО!)
echo "sdk.dir=$HOME/Android/Sdk" > local.properties
```

***

### 🔨 Блок 6: Сборка APK

**Debug версия (для тестирования):**
```bash
# Делаем gradlew исполняемым
chmod +x gradlew

# Чистая сборка
./gradlew clean assembleDebug

# APK будет здесь:
ls -lh app/build/outputs/apk/debug/app-debug.apk
```

**Release версия (для публикации):**
```bash
./gradlew assembleRelease

# APK будет здесь:
ls -lh app/build/outputs/apk/release/app-release-unsigned.apk
```

***

### 📲 Блок 7: Установка на телефон

```bash
# Включите на телефоне:
# Настройки → О телефоне → Тап 7 раз по "Номер сборки"
# Настройки → Для разработчиков → Отладка по USB

# Подключите USB-кабель и проверьте подключение
adb devices

# Установка
adb install -r app/build/outputs/apk/debug/app-debug.apk

# Или перезапись если уже установлено
adb install -r -d app/build/outputs/apk/debug/app-debug.apk
```

***

### 🐛 Блок 8: Отладка (опционально)

```bash
# Логи в реальном времени
adb logcat | grep -E "Nyazo|Screenshot|Upload"

# Только ошибки
adb logcat *:E

# Очистка логов
adb logcat -c
```

***

### ✅ Проверка что всё работает

```bash
# Java версия (должна быть 17+)
java -version

# Android SDK
sdkmanager --version

# Gradle через wrapper
./gradlew --version
```

**Готово!** APK собран и готов к установке.[1][2]

---

## 🔧 Серверные требования

Ваш `upload_new.php` должен:
- Принимать POST с `$_FILES['file']`
- Сохранять PNG файл
- Возвращать URL (например: `https://domain.com/abc123.png`)

Для удаления нужен `del.php` который:
- Принимает POST на `/del/filename.png` с полем `password`
- Проверяет пароль
- Удаляет файл

Nginx лимиты: `client_max_body_size 50M;`  
PHP лимиты: `upload_max_filesize = 50M; post_max_size = 50M;`

---

## 🐛 Отладка

```
# Логи в реальном времени
adb logcat | grep -E "Screenshot|Upload"

# Только ошибки
adb logcat *:E
```

**Типичные проблемы:**
- Скриншоты не детектируются → проверьте разрешения в приложении
- Загрузка не работает → проверьте URL сервера и лимиты nginx/php
- Сервис умирает → система убивает фоновые процессы, перезапустите

---

## 📂 Структура проекта

```
app/src/main/java/com/nyazo/android/
├── MainActivity.kt              # UI с настройками и историей
├── ScreenshotDetectionService.kt # Детектор скриншотов
├── UploadManager.kt              # Загрузка/удаление
├── ConfigManager.kt              # Настройки
├── HistoryManager.kt             # История
└── BootReceiver.kt               # Автозапуск
```

---

## 📝 Changelog

**v1.0.0** (2025-12-19)
- Первый релиз
- Автозагрузка скриншотов
- История и удаление

---

**Сделано с 🤖 нейросетью и 😴 ленью**
```
