package com.nyazo.android

import android.content.Context
import com.google.gson.Gson
import java.io.File

data class Config(
    val serverUrl: String = "https://yoursite.com/upload.php",
    val apiKey: String = "",
    val deletePassword: String = "your password for delete img"
)

class ConfigManager(private val context: Context) {
    private val configFile = File(context.filesDir, "config.json")
    private val gson = Gson()

    fun loadConfig(): Config {
        return try {
            // Сначала пробуем загрузить из внутреннего хранилища
            if (configFile.exists()) {
                val json = configFile.readText()
                gson.fromJson(json, Config::class.java)
            } else {
                // Если нет, загружаем из assets
                loadDefaultConfig()
            }
        } catch (e: Exception) {
            e.printStackTrace()
            loadDefaultConfig()
        }
    }

    private fun loadDefaultConfig(): Config {
        return try {
            val json = context.assets.open("config.json").bufferedReader().use { it.readText() }
            val config = gson.fromJson(json, Config::class.java)
            // Сохраняем в internal storage для возможности редактирования
            saveConfig(config)
            config
        } catch (e: Exception) {
            e.printStackTrace()
            Config() // Возвращаем дефолтный конфиг
        }
    }

    fun saveConfig(config: Config) {
        try {
            val json = gson.toJson(config)
            configFile.writeText(json)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }
}
