package com.nyazo.android

import android.content.Context
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken

data class ScreenshotItem(
    val url: String,
    val timestamp: Long,
    val fileName: String
)

class HistoryManager(private val context: Context) {
    private val prefs = context.getSharedPreferences("screenshot_history", Context.MODE_PRIVATE)
    private val gson = Gson()
    
    fun addScreenshot(url: String) {
        val fileName = url.substringAfterLast("/")
        val item = ScreenshotItem(url, System.currentTimeMillis(), fileName)
        
        val history = getHistory().toMutableList()
        history.add(0, item) // Добавляем в начало
        
        // Храним максимум 100 записей
        if (history.size > 100) {
            history.removeAt(history.size - 1)
        }
        
        val json = gson.toJson(history)
        prefs.edit().putString("history", json).apply()
    }
    
    fun getHistory(): List<ScreenshotItem> {
        val json = prefs.getString("history", null) ?: return emptyList()
        val type = object : TypeToken<List<ScreenshotItem>>() {}.type
        return gson.fromJson(json, type)
    }
    
    fun removeScreenshot(url: String) {
        val history = getHistory().toMutableList()
        history.removeAll { it.url == url }
        val json = gson.toJson(history)
        prefs.edit().putString("history", json).apply()
    }
    
    fun clearHistory() {
        prefs.edit().remove("history").apply()
    }
}
